/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.GeneralConfig;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketSetSlot;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketValueTypeRecipeLPElementSetRecipe;

public class LogicProgrammerTransferHandler<T extends ContainerLogicProgrammerBase>
implements IRecipeTransferHandler<T, Object> {
    private final Class<T> clazz;

    public LogicProgrammerTransferHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Class<Object> getRecipeClass() {
        return Object.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, Object recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        ILogicProgrammerElement element = ((ContainerLogicProgrammerBase)((Object)container)).getActiveElement();
        if (element != null) {
            if (element instanceof ValueTypeRecipeLPElement) {
                return this.handleRecipeElement((ValueTypeRecipeLPElement)element, container, recipeLayout, doTransfer);
            }
            return this.handleDefaultElement(element, container, recipeLayout, doTransfer);
        }
        return null;
    }

    @Nullable
    protected ResourceLocation getHeuristicItemsTag(IGuiIngredient<ItemStack> jeiIngredient) {
        if (!GeneralConfig.jeiHeuristicTags) {
            return null;
        }
        List items = jeiIngredient.getAllIngredients().stream().map(ItemStack::m_41720_).collect(Collectors.toList());
        if (items.size() > 1) {
            return ForgeRegistries.ITEMS.tags().stream().map(tag -> {
                if (tag.stream().collect(Collectors.toList()).equals(items)) {
                    return Optional.of(tag.getKey().f_203868_());
                }
                return Optional.empty();
            }).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        }
        return null;
    }

    protected IRecipeTransferError handleRecipeElement(ValueTypeRecipeLPElement element, T container, IRecipeLayout recipeLayout, boolean doTransfer) {
        ItemStack stack;
        ArrayList itemInputs = Lists.newArrayList();
        ArrayList fluidInputs = Lists.newArrayList();
        ArrayList itemOutputs = Lists.newArrayList();
        ArrayList fluidOutputs = Lists.newArrayList();
        for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
            stack = ((ItemStack)Iterables.getFirst((Iterable)((IGuiIngredient)entry.getValue()).getAllIngredients(), (Object)ItemStack.f_41583_)).m_41777_();
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                ResourceLocation heuristicTag = this.getHeuristicItemsTag((IGuiIngredient<ItemStack>)((IGuiIngredient)entry.getValue()));
                if (heuristicTag != null) {
                    itemInputs.add(new ItemMatchProperties(ItemStack.f_41583_, false, heuristicTag.toString(), 1));
                    continue;
                }
                itemInputs.add(new ItemMatchProperties(stack));
                continue;
            }
            itemOutputs.add(stack);
        }
        for (Map.Entry entry : recipeLayout.getFluidStacks().getGuiIngredients().entrySet()) {
            stack = ((FluidStack)Iterables.getFirst((Iterable)((IGuiIngredient)entry.getValue()).getAllIngredients(), (Object)FluidStack.EMPTY)).copy();
            if (stack.isEmpty()) continue;
            if (((IGuiIngredient)entry.getValue()).isInput()) {
                fluidInputs.add(stack);
                continue;
            }
            fluidOutputs.add(stack);
        }
        if (!element.isValidForRecipeGrid(itemInputs, fluidInputs, itemOutputs, fluidOutputs)) {
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(PoseStack matrixStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                    Minecraft.m_91087_().f_91080_.m_96597_(matrixStack, Collections.singletonList(new TranslatableComponent("error.jei.integrateddynamics.recipetransfer.recipe.toobig.desc")), mouseX, mouseY);
                }
            };
        }
        if (doTransfer) {
            element.setRecipeGrid((ContainerLogicProgrammerBase)((Object)container), itemInputs, fluidInputs, itemOutputs, fluidOutputs);
            IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketValueTypeRecipeLPElementSetRecipe(((ContainerLogicProgrammerBase)((Object)container)).f_38840_, itemInputs, fluidInputs, itemOutputs, fluidOutputs));
        }
        return null;
    }

    protected IRecipeTransferError handleDefaultElement(ILogicProgrammerElement element, T container, IRecipeLayout recipeLayout, boolean doTransfer) {
        ItemStack itemStack = null;
        IFocus focusItem = recipeLayout.getFocus(VanillaTypes.ITEM);
        IFocus focusFluid = recipeLayout.getFocus(VanillaTypes.FLUID);
        if (focusItem != null) {
            itemStack = (ItemStack)focusItem.getValue();
        } else if (focusFluid != null) {
            itemStack = new ItemStack((ItemLike)Items.f_42446_);
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find a fluid handler on the bucket item, some mod must be messing with things."));
            fluidHandler.fill((FluidStack)focusFluid.getValue(), IFluidHandler.FluidAction.EXECUTE);
            itemStack = fluidHandler.getContainer();
        }
        if (itemStack != null) {
            if (element.isItemValidForSlot(0, itemStack)) {
                if (doTransfer) {
                    this.setStackInSlot(container, 0, itemStack);
                }
            } else {
                return new IRecipeTransferError(){

                    public IRecipeTransferError.Type getType() {
                        return IRecipeTransferError.Type.USER_FACING;
                    }

                    public void showError(PoseStack matrixStack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
                    }
                };
            }
        }
        return null;
    }

    protected void setStackInSlot(T container, int slot, ItemStack itemStack) {
        int slotId = ((ContainerLogicProgrammerBase)((Object)container)).f_38839_.size() - 37 + slot;
        container.m_182406_(slotId, 0, itemStack.m_41777_());
        IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketSetSlot(((ContainerLogicProgrammerBase)((Object)container)).f_38840_, slotId, itemStack));
    }
}

